/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.deleteproject;

import com.google.gerrit.extensions.annotations.PluginName;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.CapabilityControl;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.config.AllProjectsNameProvider;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.googlesource.gerrit.plugins.deleteproject.CannotDeleteProjectException;
import com.googlesource.gerrit.plugins.deleteproject.cache.CacheDeleteHandler;
import com.googlesource.gerrit.plugins.deleteproject.database.DatabaseDeleteHandler;
import com.googlesource.gerrit.plugins.deleteproject.fs.FilesystemDeleteHandler;
import com.googlesource.gerrit.plugins.deleteproject.projectconfig.ProjectConfigDeleteHandler;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.jgit.errors.RepositoryNotFoundException;

class DeleteProject
implements RestModifyView<ProjectResource, Input> {
    protected final AllProjectsName allProjectsName;
    private final DatabaseDeleteHandler dbHandler;
    private final FilesystemDeleteHandler fsHandler;
    private final CacheDeleteHandler cacheHandler;
    private final ProjectConfigDeleteHandler pcHandler;
    private final Provider<CurrentUser> userProvider;
    private final String pluginName;

    @Inject
    DeleteProject(AllProjectsNameProvider allProjectsNameProvider, DatabaseDeleteHandler dbHandler, FilesystemDeleteHandler fsHandler, CacheDeleteHandler cacheHandler, ProjectConfigDeleteHandler pcHandler, Provider<CurrentUser> userProvider, @PluginName String pluginName) {
        this.allProjectsName = allProjectsNameProvider.get();
        this.dbHandler = dbHandler;
        this.fsHandler = fsHandler;
        this.cacheHandler = cacheHandler;
        this.pcHandler = pcHandler;
        this.userProvider = userProvider;
        this.pluginName = pluginName;
    }

    public Object apply(ProjectResource rsrc, Input input) throws ResourceNotFoundException, ResourceConflictException, MethodNotAllowedException, OrmException, IOException, AuthException {
        Collection<String> warnings;
        if (!this.canDelete(rsrc)) {
            throw new AuthException("not allowed to delete project");
        }
        try {
            this.pcHandler.assertCanDelete(rsrc);
        }
        catch (CannotDeleteProjectException e) {
            throw new MethodNotAllowedException(e.getMessage());
        }
        Project project = rsrc.getControl().getProject();
        try {
            this.dbHandler.assertCanDelete(project);
        }
        catch (CannotDeleteProjectException e) {
            throw new ResourceConflictException(e.getMessage());
        }
        if (!(input != null && input.force || (warnings = this.dbHandler.getWarnings(project)).isEmpty())) {
            throw new ResourceConflictException(String.format("Project %s has open changes", project.getName()));
        }
        this.dbHandler.delete(project);
        try {
            this.fsHandler.delete(project, input == null ? false : input.preserve);
        }
        catch (RepositoryNotFoundException e) {
            throw new ResourceNotFoundException();
        }
        this.cacheHandler.delete(project);
        return Response.none();
    }

    protected boolean canDelete(ProjectResource rsrc) {
        CapabilityControl ctl = ((CurrentUser)this.userProvider.get()).getCapabilities();
        return ctl.canAdministrateServer() || ctl.canPerform(this.pluginName + "-" + "deleteProject") || ctl.canPerform(this.pluginName + "-" + "deleteOwnProject") && rsrc.getControl().isOwner();
    }

    protected boolean isAllProjects(ProjectResource rsrc) {
        return rsrc.getControl().getProject().getNameKey().equals((Object)this.allProjectsName);
    }

    static class Input {
        boolean preserve;
        boolean force;

        Input() {
        }
    }
}

