/*
 * Decompiled with CFR 0.152.
 */
package com.rackspace.cloud.api.docs.pipeline.resolvers;

import com.rackspace.cloud.api.docs.pipeline.resolvers.SourceUriResolver;
import java.io.InputStream;
import java.net.URISyntaxException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;

public class ClassPathUriResolver
extends SourceUriResolver {
    public static final String CLASSPATH_PREFIX = "classpath://";

    public ClassPathUriResolver() {
    }

    public ClassPathUriResolver(URIResolver parent) {
        super(parent);
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        if (href != null && href.toLowerCase().startsWith(CLASSPATH_PREFIX)) {
            String path = href.substring(CLASSPATH_PREFIX.length());
            InputStream resource = this.getClass().getResourceAsStream(path);
            if (resource == null) {
                return null;
            }
            try {
                return new StreamSource(resource, this.getClass().getResource(path).toURI().toString());
            }
            catch (URISyntaxException ex) {
                return new StreamSource(resource);
            }
        }
        return super.resolve(href, base);
    }
}

