/*
 * Decompiled with CFR 0.152.
 */
package com.rackspace.cloud.api.docs.pipeline;

import com.rackspace.cloud.api.docs.pipeline.CalabashPipeline;
import com.rackspace.cloud.api.docs.pipeline.Pipeline;
import com.rackspace.cloud.api.docs.pipeline.PipelineBuilder;
import com.rackspace.cloud.api.docs.pipeline.PipelineException;
import com.rackspace.cloud.api.docs.pipeline.resolvers.ClassPathUriResolver;
import com.rackspace.cloud.api.docs.pipeline.resolvers.InputStreamUriParameterResolver;
import com.xmlcalabash.core.XProcConfiguration;
import com.xmlcalabash.core.XProcMessageListener;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.runtime.XPipeline;
import com.xmlcalabash.util.Input;
import com.xmlcalabash.util.XProcURIResolver;
import javax.xml.transform.URIResolver;
import net.sf.saxon.s9api.SaxonApiException;

public class CalabashPipelineBuilder
implements PipelineBuilder {
    private final boolean schemaAware;
    private final boolean legacySourceOutput;
    private XProcMessageListener messageListener;

    public CalabashPipelineBuilder() {
        this(true, false);
    }

    public CalabashPipelineBuilder(boolean schemaAware) {
        this(schemaAware, false);
    }

    public CalabashPipelineBuilder(boolean schemaAware, boolean legacySourceOutput) {
        this.schemaAware = schemaAware;
        this.legacySourceOutput = legacySourceOutput;
    }

    public CalabashPipelineBuilder(boolean schemaAware, boolean legacySourceOutput, XProcMessageListener messageListener) {
        this.schemaAware = schemaAware;
        this.legacySourceOutput = legacySourceOutput;
        this.messageListener = messageListener;
    }

    @Override
    public Pipeline build(String pipelineUri) {
        try {
            XProcConfiguration config = new XProcConfiguration(this.schemaAware);
            XProcRuntime runtime = new XProcRuntime(config);
            if (this.messageListener != null) {
                runtime.setMessageListener(this.messageListener);
            }
            InputStreamUriParameterResolver resolver = new InputStreamUriParameterResolver((URIResolver)new XProcURIResolver(runtime));
            resolver.addResolver(new ClassPathUriResolver());
            runtime.setURIResolver((URIResolver)resolver);
            XPipeline pipeline = runtime.load(new Input(pipelineUri));
            return new CalabashPipeline(pipeline, runtime, resolver, this.legacySourceOutput);
        }
        catch (SaxonApiException ex) {
            throw new PipelineException(ex);
        }
    }

    @Override
    public Pipeline build(String pipelineUri, URIResolver ... resolvers) {
        try {
            XProcConfiguration config = new XProcConfiguration(this.schemaAware);
            XProcRuntime runtime = new XProcRuntime(config);
            InputStreamUriParameterResolver streamResolver = new InputStreamUriParameterResolver((URIResolver)new XProcURIResolver(runtime));
            streamResolver.addResolver(new ClassPathUriResolver());
            for (URIResolver resolver : resolvers) {
                streamResolver.addResolver(resolver);
            }
            runtime.setURIResolver((URIResolver)streamResolver);
            XPipeline pipeline = runtime.load(new Input(pipelineUri));
            return new CalabashPipeline(pipeline, runtime, streamResolver);
        }
        catch (SaxonApiException ex) {
            throw new PipelineException(ex);
        }
    }
}

