/*
 * Decompiled with CFR 0.152.
 */
package com.rackspace.cloud.api.docs.pipeline;

import com.rackspace.cloud.api.docs.pipeline.Pipeline;
import com.rackspace.cloud.api.docs.pipeline.PipelineInput;
import com.rackspace.cloud.api.docs.pipeline.resolvers.InputStreamUriParameterResolver;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractPipeline
implements Pipeline {
    private static final Logger LOG = Logger.getLogger(AbstractPipeline.class.getName());
    private final InputStreamUriParameterResolver resolver;

    public AbstractPipeline(InputStreamUriParameterResolver resolver) {
        this.resolver = resolver;
    }

    protected abstract <T> void addParameter(PipelineInput<T> var1);

    protected abstract <T> void addPort(PipelineInput<T> var1);

    protected abstract <T> void addOption(PipelineInput<T> var1);

    protected void handleInputs(PipelineInput<?> ... inputs) {
        this.handleInputs(Arrays.asList(inputs));
    }

    protected void handleInputs(List<PipelineInput<?>> inputs) {
        block5: for (PipelineInput<?> input : inputs) {
            switch (input.getType()) {
                case PORT: {
                    this.addPort(input);
                    continue block5;
                }
                case PARAMETER: {
                    this.addParameter(input);
                    continue block5;
                }
                case OPTION: {
                    this.addOption(input);
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Input type not supported: " + (Object)((Object)input.getType()));
        }
    }

    protected InputStreamUriParameterResolver getUriResolver() {
        return this.resolver;
    }

    protected <T> void clearParameter(PipelineInput<T> input) {
        T source = input.getSource();
        if (source instanceof InputStream) {
            try {
                ((InputStream)source).close();
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, "Unable to close input stream. Reason: " + ex.getMessage(), ex);
            }
            this.resolver.removeStream((InputStream)source);
        }
    }

    protected void clearParameters(PipelineInput<?> ... inputs) {
        this.clearParameters(Arrays.asList(inputs));
    }

    protected void clearParameters(List<PipelineInput<?>> inputs) {
        for (PipelineInput<?> input : inputs) {
            switch (input.getType()) {
                case PARAMETER: {
                    this.clearParameter(input);
                    break;
                }
            }
        }
    }

    @Override
    public void run(PipelineInput<?> ... inputs) {
        this.run(Arrays.asList(inputs));
    }
}

