/*
 * Decompiled with CFR 0.152.
 */
package com.rackspace.cloud.api.docs.pipeline;

import com.rackspace.cloud.api.docs.pipeline.AbstractPipeline;
import com.rackspace.cloud.api.docs.pipeline.Pipeline;
import com.rackspace.cloud.api.docs.pipeline.PipelineException;
import com.rackspace.cloud.api.docs.pipeline.PipelineInput;
import com.rackspace.cloud.api.docs.pipeline.resolvers.InputStreamUriParameterResolver;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XPipeline;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.xml.sax.InputSource;

public class CalabashPipeline
extends AbstractPipeline
implements Pipeline {
    private final XProcRuntime runtime;
    private final XPipeline pipeline;
    private final boolean legacySourceOutput;

    public CalabashPipeline(XPipeline pipeline, XProcRuntime runtime, InputStreamUriParameterResolver resolver) {
        this(pipeline, runtime, resolver, false);
    }

    public CalabashPipeline(XPipeline pipeline, XProcRuntime runtime, InputStreamUriParameterResolver resolver, boolean legacySourceOutput) {
        super(resolver);
        this.runtime = runtime;
        this.pipeline = pipeline;
        this.legacySourceOutput = legacySourceOutput;
    }

    protected <T> RuntimeValue getRuntimeValue(PipelineInput<T> input) {
        RuntimeValue runtimeValue;
        T source = input.getSource();
        if (source instanceof InputStream) {
            runtimeValue = new RuntimeValue(this.getUriResolver().addStream((InputStream)source));
        } else if (source instanceof String) {
            runtimeValue = new RuntimeValue(source.toString());
        } else {
            throw new IllegalArgumentException("Illegal input type: " + source.getClass().getName());
        }
        return runtimeValue;
    }

    @Override
    protected <T> void addParameter(PipelineInput<T> input) {
        RuntimeValue runtimeParam = this.getRuntimeValue(input);
        if (this.pipeline.getInputs().contains("parameters")) {
            this.pipeline.setParameter("parameters", new QName("", input.getName()), runtimeParam);
        } else {
            this.pipeline.setParameter(new QName("", input.getName()), runtimeParam);
        }
    }

    @Override
    protected <T> void addOption(PipelineInput<T> input) {
        this.pipeline.setOption(new QName(input.getName()), this.getRuntimeValue(input));
    }

    @Override
    protected <T> void addPort(PipelineInput<T> input) {
        XdmNode node;
        T source = input.getSource();
        if (source instanceof InputSource) {
            node = this.runtime.parse((InputSource)source);
        } else if (input.getSource() instanceof XdmNode) {
            node = (XdmNode)source;
        } else {
            throw new IllegalArgumentException("Illegal port type: " + source.getClass().getName());
        }
        this.pipeline.writeTo(input.getName(), node);
    }

    @Override
    public void reset() {
        this.pipeline.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(List<PipelineInput<?>> inputs) {
        try {
            this.reset();
            this.handleInputs(inputs);
            try {
                this.pipeline.run();
            }
            finally {
                this.clearParameters(inputs);
            }
        }
        catch (SaxonApiException ex) {
            throw new PipelineException(ex);
        }
    }

    @Override
    public List<Source> getResultPort(String name) {
        List<Source> ret = null;
        ret = !this.legacySourceOutput ? this.getCalabashResultPort(name) : this.getLegacyResultPort(name);
        return ret;
    }

    protected List<Source> getCalabashResultPort(String name) {
        try {
            ReadablePipe pipe = this.pipeline.readFrom(name);
            ArrayList<Source> nodes = new ArrayList<Source>();
            while (pipe.moreDocuments()) {
                nodes.add(pipe.read().asSource());
            }
            return nodes;
        }
        catch (SaxonApiException ex) {
            throw new PipelineException(ex);
        }
    }

    protected List<Source> getLegacyResultPort(String name) {
        try {
            List<Source> standard = this.getCalabashResultPort(name);
            ArrayList<Source> ret = new ArrayList<Source>(standard.size());
            TransformerFactory transFactory = TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", null);
            Transformer transformer = transFactory.newTransformer();
            for (Source s : standard) {
                DOMResult result = new DOMResult();
                transformer.transform(s, result);
                ret.add(new DOMSource(result.getNode()));
            }
            return ret;
        }
        catch (TransformerConfigurationException tce) {
            throw new PipelineException(tce);
        }
        catch (TransformerException te) {
            throw new PipelineException(te);
        }
    }
}

